## Importing and attaching data into R
rm(list=ls())
file.choose()
Raw_Data <- read.table("D:\\UJ\\PhD UJ\\Attempt 2\\Chapters\\Publication I_Objective 3\\2nd Attempt\\Analysis\\Research_Data.txt", header = TRUE)
attach(Raw_Data)

## Data Imputation using Multivariate Imputation by Chained Equations (MICE package)
library(mice)

tempData <- mice(Raw_Data,m=5,maxit=50,meth='cart')

CompletedData <- complete(tempData,1)

          #Saving imputed data to local computer
          install.packages("writexl")
          library("writexl")
          write_xlsx(CompletedData,"D:\\UJ\\PhD UJ\\Attempt 2\\Chapters\\Publication I_Objective 
           3\\2nd Attempt\\Analysis\\Objective 1\\CompletedData.xlsx") 

## Importing and attaching imputed data into R
Data_set <- read.table("D:\\UJ\\PhD UJ\\Attempt 2\\Chapters\\Publication I_Objective 3\\2nd Attempt\\Analysis\\Objective 1\\Clean_Data.txt", header = TRUE)
attach(Data_set)


## Stepwise Regression (1st Indicator Selection Nmodel)

GLM_Model_1 <- glm(Data_set$POP~Data_set$AMP, family = "gaussian")
GLM_Model_2 <- glm(Data_set$POP~Data_set$PAR, family = "gaussian")
GLM_Model_3 <- glm(Data_set$POP~Data_set$SHI, family = "gaussian")
GLM_Model_4 <- glm(Data_set$POP~Data_set$SPI, family = "gaussian")
GLM_Model_5 <- glm(Data_set$POP~Data_set$FSS, family = "gaussian")
GLM_Model_6 <- glm(Data_set$POP~Data_set$CTH, family = "gaussian")
GLM_Model_7 <- glm(Data_set$POP~Data_set$TPA, family = "gaussian")
GLM_Model_8 <- glm(Data_set$POP~Data_set$WTA, family = "gaussian")
GLM_Model_9 <- glm(Data_set$POP~Data_set$GRA, family = "gaussian")
GLM_Model_10 <- glm(Data_set$POP~Data_set$CH4, family = "gaussian")
GLM_Model_11 <- glm(Data_set$POP~Data_set$FOG, family = "gaussian")
GLM_Model_12 <- glm(Data_set$POP~Data_set$NOT, family = "gaussian")
GLM_Model_13 <- glm(Data_set$POP~Data_set$NOX, family = "gaussian")
GLM_Model_14 <- glm(Data_set$POP~Data_set$BLC, family = "gaussian")
GLM_Model_15 <- glm(Data_set$POP~Data_set$SO2, family = "gaussian")
GLM_Model_16 <- glm(Data_set$POP~Data_set$CDL, family = "gaussian")
GLM_Model_17 <- glm(Data_set$POP~Data_set$SNM, family = "gaussian")
GLM_Model_18 <- glm(Data_set$POP~Data_set$CCO, family = "gaussian")
GLM_Model_19 <- glm(Data_set$POP~Data_set$GOE, family = "gaussian")
GLM_Model_20 <- glm(Data_set$POP~Data_set$ROL, family = "gaussian")
GLM_Model_21 <- glm(Data_set$POP~Data_set$RQU, family = "gaussian")
GLM_Model_22 <- glm(Data_set$POP~Data_set$SAV, family = "gaussian")
GLM_Model_23 <- glm(Data_set$POP~Data_set$VOA, family = "gaussian")
GLM_Model_24 <- glm(Data_set$POP~Data_set$SEG, family = "gaussian")
GLM_Model_25 <- glm(Data_set$POP~Data_set$EEZ, family = "gaussian")
GLM_Model_26 <- glm(Data_set$POP~Data_set$GDP, family = "gaussian")
GLM_Model_27 <- glm(Data_set$POP~Data_set$IEF, family = "gaussian")


summary(GLM_Model)

##SEM (Using Lavaan) (Indicators from 1st method of selection)
library(lavaan)
library(corrplot)
library(semPlot)
library(MPsychoR)

Model_A <- ' #Latent Variables
              Air pollution =~CH4
              Biodiversity =~SPI
              Environmental Management =~ SNM
              Governance =~ CCO
              Economy =~ GDP
              Population =~POP
              
              #Covariances
              Biodiversity ~~ Biodiversity
              Environmental Management ~~ Environmental Management
              Governance ~~ Governance
              Economy ~~ Economy
              Air pollution ~~ Air pollution
              Population ~~ Population
              
              #Regression Models
             Population~Air pollution + Biodiversity + Environmental Management + Governance+ Economy
             Environmental Management ~ Governance
             Biodiversity ~  Environmental Management + Air pollution + Governance + Economy
             Economy ~ Governance
             Air pollution ~ Economy + Governance
                          '

Model_A.fit <- sem(Model_A,
                   data = Data_set,
                   estimator= "ML",
                   check.gradient = FALSE,
                   meanstructure= FALSE)


summary(Model_A.fit,
        standardized=TRUE,
        fit.measures = TRUE,
        rsquare = TRUE)

              ##  SEM excluding Environmental Management variable
Model_B <- ' #Latent Variables
              Air pollution =~ CH4
              Biodiversity =~SPI
              Economy =~ GDP
              Governance =~ CCO
              Population =~POP
              
              #Covariances and Variances
              Biodiversity~~Biodiversity
              Governance ~~Governance
              Economy~~Economy
              Air pollution ~~Air pollution
              Population ~~ Population
              
              #Regression Models
              Population~Air pollution + Biodiversity +  Governance+ Economy
              Biodiversity ~  Air pollution + Governance + Economy
              Economy ~Governance
              Air pollution ~ Economy + Governance
              '

Model_B.fit <- sem(Model_B,
                   data = Data_set,
                   estimator= "ML",
                   check.gradient = FALSE,
                   meanstructure= FALSE)

summary(Model_B.fit,
        standardized=TRUE,
        fit.measures = TRUE,
        rsquare = TRUE)



####Pairs correlation: Spearman and Pearson (2nd Indicator Selection Model)

SAAQIS <- read.table("D:\\UJ\\PhD UJ\\Attempt 2\\Chapters\\Publication I_Objective 3\\2nd Attempt\\Analysis\\Objective 1\\Pairs Test\\Air Quality.txt", header = TRUE)
SANBI <- read.table( "D:\\UJ\\PhD UJ\\Attempt 2\\Chapters\\Publication I_Objective 3\\2nd Attempt\\Analysis\\Objective 1\\Pairs Test\\Biodiverse.txt", header = TRUE)
SARS <- read.table( "D:\\UJ\\PhD UJ\\Attempt 2\\Chapters\\Publication I_Objective 3\\2nd Attempt\\Analysis\\Objective 1\\Pairs Test\\Economy.txt", header = TRUE)
ANC <- read.table("D:\\UJ\\PhD UJ\\Attempt 2\\Chapters\\Publication I_Objective 3\\2nd Attempt\\Analysis\\Objective 1\\Pairs Test\\Governance.txt", header = TRUE)

cor(SAAQIS[, c("BLC","SO2","CDL","CH4","FOG","NOT","NOX")], method = "spearman")
cor(SANBI[, c("AMP","PAR","SHI","SPI","FSS","CTH","TPA", "WTA","GRA")], method = "spearman")
cor(SARS[, c("SEG","EEZ","GDP","IEF")], method = "spearman")
cor(ANC[, c("CCO","GOE","ROL","RQU","SAV","VOA")], method = "spearman")


##  SEM using Indicators from 2nd selection method.

Model_C <- ' #Latent Variables
              Air pollution =~ CH4
              Biodiversity =~WTA
              Economy =~ GDP
              Governance =~ GOE
              Population =~POP
              
              #Covariances and Variances
              Biodiversity~~Biodiversity
              Governance ~~Governance
              Economy~~Economy
              Air pollution ~~Air pollution
              Population ~~ Population
              
              #Regression Models
              Population~Air pollution + Biodiversity +  Governance+ Economy
              Biodiversity ~  Air pollution + Governance + Economy
              Economy ~Governance
              Air pollution ~ Economy + Governance
              '

Model_C.fit <- sem(Model_C,
                   data = Data_set,
                   estimator= "ML",
                   check.gradient = FALSE,
                   meanstructure= FALSE)

summary(Model_C.fit,
        standardized=TRUE,
        fit.measures = TRUE,
        rsquare = TRUE)
